local tick_adjust = 2/1.8
local blank = {
  filename = "__omnimatter_crystal__/graphics/blank.png",
  priority = "high",
  width = 1,
  height = 1,
  frame_count = 1
}
local crystal_reactor = {
  type = "boiler",
  name = "crystal-reactor",
  icon = "__omnimatter_crystal__/graphics/icons/crystal-reactor.png",
  flags = {"placeable-neutral", "player-creation"},
  minable = {hardness = 0.2, mining_time = 0.5, result = "crystal-reactor"},
  max_health = 250,
  corpse = "small-remnants",
  vehicle_impact_sound =  { filename = "__base__/sound/car-metal-impact.ogg", volume = 0.65 },
  mode = "output-to-separate-pipe",
  resistances =
  {
    { type = "fire", percent = 100 },
    { type = "explosion", percent = 30 },
    { type = "impact", percent = 50 }
  },
  selection_box = {{-3,-3}, {3,3}},
  collision_box = {{-2.4, -2.4}, {2.4, 2.4}},
  target_temperature = 165,
  fluid_input = { name = "water", amount = 0.0 },
  fluid_output = { name = "steam", amount = 10.0 },
  fluid_box =
  {
    base_area = 0.5,
    height = 2,
    base_level = -1,
    production_type = "input-output",
    pipe_connections = {},
  },
  output_fluid_box =
  {
    base_area = 0.5,
    height = 2,
    production_type = "output",
    pipe_connections = {},
  },
  energy_consumption = "1MW",
  energy_source =
  {
    type = "burner",
    fuel_category = "crystal",
    effectivity = 1,
    fuel_inventory_size = 4,
    emissions = 0,
  },
  working_sound =
  {
    sound =
    {
      filename = "__base__/sound/furnace.ogg",
      volume = 1.6
    },
    max_sounds_per_type = 3
  },
  fire_flicker_enabled = true,
  fire_glow_flicker_enabled = false,
  burning_cooldown = 20
}

local layers = {
  layers =
  {
    {
      filename = "__omnimatter_crystal__/graphics/buildings/crystal-reactor.png",
      priority = "extra-high",
      line_length = 4,
      frame_count = 16,
      animation_speed = 0.5,
      width = 1280/4,
      height = 1280/4,
      shift = {2,-2},
    },
  }
}
crystal_reactor.structure = {}
crystal_reactor.structure.north = layers
crystal_reactor.structure.south = layers
crystal_reactor.structure.east = layers
crystal_reactor.structure.west = layers
local fire = {
  filename = "__aai-industry__/graphics/entity/burner-turbine/burner-turbine-glow.png",
  priority = "extra-high",
  line_length = 4,
  frame_count = 8,
  animation_speed = 0.5,
  width = 540/4,
  height = 300/2,
  shift = util.by_pixel(0, -10),
  blend_mode = "additive",
  hr_version = {
    filename = "__aai-industry__/graphics/entity/burner-turbine/hr-burner-turbine-glow.png",
    priority = "extra-high",
    line_length = 4,
    frame_count = 8,
    animation_speed = 0.5,
    width = 540/2,
    height = 300,
    shift = util.by_pixel(0, -10),
    scale = 0.5,
    blend_mode = "additive",
  }
}
crystal_reactor.fire = {}
crystal_reactor.fire.north = layers
crystal_reactor.fire.south = layers
crystal_reactor.fire.east = layers
crystal_reactor.fire.west = layers

local fire_glow = {
  filename = "__aai-industry__/graphics/entity/burner-turbine/burner-turbine.png",
  priority = "extra-high",
  line_length = 4,
  frame_count = 8,
  animation_speed = 0.5,
  width = 540/4,
  height = 300/2,
  shift = util.by_pixel(0, -10),
  hr_version = {
    filename = "__aai-industry__/graphics/entity/burner-turbine/hr-burner-turbine.png",
    priority = "extra-high",
    line_length = 4,
    frame_count = 8,
    animation_speed = 0.5,
    width = 540/2,
    height = 300,
    shift = util.by_pixel(0, -10),
    scale = 0.5
  }
}
crystal_reactor.fire_glow = {}
crystal_reactor.fire_glow.north = layers
crystal_reactor.fire_glow.south = layers
crystal_reactor.fire_glow.east = layers
crystal_reactor.fire_glow.west = layers

data:extend({crystal_reactor})

local crystal_reactor_generator = {
  type = "generator",
  name = "crystal-reactor-generator",
  icon = "__omnimatter_crystal__/graphics/icons/crystal-reactor.png",
  flags = {"placeable-neutral","player-creation", "placeable-off-grid", "not-blueprintable", "not-deconstructable"},
  max_health = 10000,
  healing_per_tick = 10000,
  corpse = "big-remnants",
  dying_explosion = "medium-explosion",
  effectivity = 1, -- fix for exactly 1 fluid per tick
  order="z",
  fluid_usage_per_tick = 1,
  maximum_temperature = 165,
  selectable_in_game = false,
  selection_box = {{-3,-3}, {3,3}},
  collision_box = {{-2.4, -2.4}, {2.4, 2.4}},
  collision_mask = {"not-colliding-with-itself"},
  fluid_box =
  {
    base_area = 0.5,
    height = 2,
    base_level = -1,
    production_type = "input-output",
    pipe_connections = {}
  },
  fluid_input = { name = "steam", amount = 10.0, minimum_temperature = 100.0 },
  energy_source = { type = "electric", usage_priority = "secondary-output", render_no_network_icon = false},
  horizontal_animation = { layers = { blank }, },
  vertical_animation = { layers = { blank }, },
  vehicle_impact_sound =  { filename = "__base__/sound/car-metal-impact.ogg", volume = 0.65 },
  min_perceived_performance = 0.25,
  performance_to_sound_speedup = 0.5,
  working_sound =
  {
    sound =
    {
      filename = "__base__/sound/boiler.ogg",
      volume = 0.8
    },
    max_sounds_per_type = 3
  },
}
data:extend({crystal_reactor_generator})
